
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_BloodProduct : BaseTest 
	{
		
		private DataTable _dtBloodProduct;
		private string _productCode = string.Empty;
		private System.Guid _inactiveBloodProductGuid;
		private System.Guid _activeBloodProductGuid;
		private System.Guid _hcpcsBloodProductGuid;
		private System.Guid _activeShipperGuid;
		private System.Guid _shipperProductGuid;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
                this._dtBloodProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 B.* FROM BloodProduct B JOIN ProductShipper PS ON B.BloodProductGuid = PS.BloodProductGuid WHERE B.RecordStatusCode = 'A' AND PS.RecordStatusCode = 'A' AND PS.DivisionCode = '" + this.TestDivisionCode + "'", true);
				this._productCode = this._dtBloodProduct.Rows[0][TABLES.BloodProduct.ProductCode].ToString();

				//Get an active BloodProductGuid*******************************************************
				DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 BloodProductGuid FROM ProductShipper WHERE DivisionCode = '" + this.TestDivisionCode + "' AND RecordStatusCode = 'A' AND BloodProductGuid IN (SELECT DISTINCT BloodProductGuid FROM BloodUnit WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "')", true);
				this._activeBloodProductGuid = (System.Guid)dtTemp.Rows[0][TABLES.BloodProduct.BloodProductGuid];

				//Get an inactive BloodProductGuid*******************************************************
				dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 BloodProductGuid FROM BloodProduct WHERE BloodProductGuid NOT IN (SELECT DISTINCT BloodProductGuid FROM ProductShipper WHERE DivisionCode = '" + this.TestDivisionCode + "')",  true);
				this._inactiveBloodProductGuid = (System.Guid)dtTemp.Rows[0][TABLES.BloodProduct.BloodProductGuid];

				//Get Product with Hcpcs Information*******************************************************
				dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM HcpcsAssignment WHERE DivisionCode ='" + this.TestDivisionCode + "'",  true);
				this._hcpcsBloodProductGuid = (System.Guid)dtTemp.Rows[0][TABLES.HcpcsAssignment.BloodProductGuid];
				
				//Get Active ProductShipperGuid*******************************************************
				dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM ProductShipper WHERE RecordStatusCode = 'A' AND DivisionCode ='" + this.TestDivisionCode + "'", true);
				this._activeShipperGuid = (System.Guid)dtTemp.Rows[0][TABLES.ProductShipper.LocalSupplierGuid];
				this._shipperProductGuid = (System.Guid)dtTemp.Rows[0][TABLES.ProductShipper.BloodProductGuid];

				this.RefreshData = false;
			}

		}

		[Test]
		public void GetBloodProductByCode_Pass()
		{
			DataTable dtTest = BloodProduct.GetBloodProductByCode(this._productCode);
			
			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(15, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.BloodProductGuid), TABLES.BloodProduct.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassName), TABLES.ComponentClass.ComponentClassName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductCode), TABLES.BloodProduct.ProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.AboRhConfirmationRequired), TABLES.ProductType.AboRhConfirmationRequired);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductVolume), TABLES.BloodProduct.ProductVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.BarcodeType), ARTIFICIAL.BarcodeType);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ProductActiveIndicator), ARTIFICIAL.ProductActiveIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.HcpcsAssignment.HcpcsCode), TABLES.HcpcsAssignment.HcpcsCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductAttributeForm), TABLES.BloodProduct.ProductAttributeForm);
		}

		[Test]
		public void GetBloodProductByCode_Fail()
		{
			DataTable dtTest = BloodProduct.GetBloodProductByCode(string.Empty);
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetActiveOrLocalBloodProductsByCode_Pass()
		{
			// Get 'L' (local) product code
			string query = "SELECT TOP 1 ProductCode FROM BloodProduct WHERE ProductCode LIKE '27%'";
			string productCode = Convert.ToString( UnitTestUtil.RunSQLGetDataRow(query)[TABLES.BloodProduct.ProductCode] );
			//
			DataTable dtTest = BloodProduct.GetActiveOrLocalBloodProductsByCode(productCode);
			//
			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(14, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.BloodProductGuid), TABLES.BloodProduct.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassName), TABLES.ComponentClass.ComponentClassName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductCode), TABLES.BloodProduct.ProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductVolume), TABLES.BloodProduct.ProductVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.BarcodeType), ARTIFICIAL.BarcodeType);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ProductActiveIndicator), ARTIFICIAL.ProductActiveIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.HcpcsAssignment.HcpcsCode), TABLES.HcpcsAssignment.HcpcsCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductAttributeForm), TABLES.BloodProduct.ProductAttributeForm);
		}

		[Test]
		public void GetActiveOrLocalBloodProductsByCode_Fail()
		{
			DataTable dtTest = BloodProduct.GetActiveOrLocalBloodProductsByCode(string.Empty);
			//
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void IsBloodProductOnActiveUnits_Pass()
		{
			DataTable dtActive = UnitTestUtil.RunSQLGetDataTable(
				"SELECT TOP 1 BloodProductGUID, LocalSupplierGuid FROM dbo.vw_BloodShipAllCurrent BU WHERE DivisionCode = '" 
				+ this.TestDivisionCode 
				+ "' AND RecordStatusCode NOT IN ('E','X') AND UnitStatusCode IN  ('A', 'C', 'I', 'L', 'S') "
				+ "AND IncomingShipmentGuid IN (SELECT IncomingShipmentGuid FROM dbo.BloodUnitShipment BUS " 
				+ "JOIN dbo.Shipment S ON S.LocalSupplierGuid = LocalSupplierGuid AND S.ShipmentGuid = BUS.IncomingShipmentGuid "
				+ "WHERE BU.BloodUnitGuid = BUS.BloodUnitGuid AND BUS.RecordStatusCode = 'A' ) ", true);
			//
			System.Guid bpGuid = (System.Guid)dtActive.Rows[0][TABLES.ProductShipper.BloodProductGuid];
			System.Guid lsGuid = (System.Guid)dtActive.Rows[0][TABLES.ProductShipper.LocalSupplierGuid];
			//
			bool retValue = DAL.BloodProduct.IsBloodProductOnActiveUnits(bpGuid, lsGuid);
			//
			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		public void IsBloodProductOnActiveUnits_Fail()
		{
			DataTable dtInactive = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 BloodProductGuid FROM BloodProduct WHERE BloodProductGuid NOT IN (SELECT DISTINCT BloodProductGuid FROM BloodUnit)");

			System.Guid bpGuid = (System.Guid)dtInactive.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			System.Guid lsGuid = DataCreator.GetRecordGuid("SELECT TOP 1 LocalSupplierGuid FROM Shipment WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'");

			bool retValue = DAL.BloodProduct.IsBloodProductOnActiveUnits(bpGuid, lsGuid);

			Assert.AreEqual(false, retValue, "ReturnValue");
		}

		[Test]
		public void GetHcpcsAssignmentHistory_Pass()
		{
			DataTable dtTest = DAL.BloodProduct.GetHcpcsAssignmentHistory(this._hcpcsBloodProductGuid);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(6, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.HcpcsAssignment.HcpcsCode), TABLES.HcpcsAssignment.HcpcsCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.HcpcsAssignment.AssignedDate), TABLES.HcpcsAssignment.AssignedDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.HcpcsAssignment.UnAssignedDate), TABLES.HcpcsAssignment.UnAssignedDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.HcpcsAssignment.HcpcsAssignmentGuid), TABLES.HcpcsAssignment.HcpcsAssignmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.HcpcsAssignment.BloodProductGuid), TABLES.HcpcsAssignment.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.HcpcsAssignment.RowVersion), TABLES.HcpcsAssignment.RowVersion);

		}

		[Test]
		public void GetHcpcsAssignmentHistory_Fail()
		{
			DataTable dtTest = BloodProduct.GetHcpcsAssignmentHistory(System.Guid.NewGuid());
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetEmptyBloodProductTable_Pass()
		{
			DataTable dtTest = DAL.BloodProduct.GetEmptyBloodProductTable();

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count" );
			Assert.AreEqual(13, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.BloodProductGuid), TABLES.BloodProduct.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.CrossmatchRequiredIndicator), TABLES.BloodProduct.CrossmatchRequiredIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.LastUpdateUser), TABLES.BloodProduct.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductAttributeForm), TABLES.BloodProduct.ProductAttributeForm);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductCode), TABLES.BloodProduct.ProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductCodeIndicator), TABLES.BloodProduct.ProductCodeIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductModificationIndicator), TABLES.BloodProduct.ProductModificationIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductVolume), TABLES.BloodProduct.ProductVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.RecordStatusCode), TABLES.BloodProduct.RecordStatusCode);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEmptyBloodProductTable_Fail()
		{
		}

		[Test]
		public void GetEmptyHcpcsAssignmentTableSchema_Pass()
		{
			DataTable dtTest = DAL.BloodProduct.GetEmptyHcpcsAssignmentTableSchema(true);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(4, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(TABLES.HcpcsAssignment.TableName, dtTest.TableName, "TableName");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.HcpcsAssignment.HcpcsAssignmentGuid), TABLES.HcpcsAssignment.HcpcsAssignmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.HcpcsAssignment.DivisionCode), TABLES.HcpcsAssignment.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.HcpcsAssignment.LastUpdateFunctionId), TABLES.HcpcsAssignment.LastUpdateFunctionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.HcpcsAssignment.RowVersion), TABLES.HcpcsAssignment.RowVersion);
		}

		[Test]
		public void GetEmptyHcpcsAssignmentTableSchema_Fail()
		{
			DataTable dtTest = DAL.BloodProduct.GetEmptyHcpcsAssignmentTableSchema(false);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(TABLES.HcpcsAssignment.TableName, dtTest.TableName, "TableName");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.HcpcsAssignment.HcpcsAssignmentGuid), TABLES.HcpcsAssignment.HcpcsAssignmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.HcpcsAssignment.DivisionCode), TABLES.HcpcsAssignment.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.HcpcsAssignment.LastUpdateFunctionId), TABLES.HcpcsAssignment.LastUpdateFunctionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.HcpcsAssignment.BloodProductGuid), TABLES.HcpcsAssignment.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.HcpcsAssignment.HcpcsCode), TABLES.HcpcsAssignment.HcpcsCode);
		}


		[Test]
		public void IsBloodProductActive_Pass()
		{
			bool retValue = DAL.BloodProduct.IsBloodProductActive(this._activeBloodProductGuid);

			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		public void IsBloodProductActive_Fail()
		{
			bool retValue = BloodProduct.IsBloodProductActive(this._inactiveBloodProductGuid);

			Assert.AreEqual(false, retValue, "ReturnValue");
		}

		[Test]
		public void IsProductShipperActive_Pass()
		{
			bool retValue = DAL.BloodProduct.IsProductShipperActive(this._shipperProductGuid, this._activeShipperGuid);

			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		public void IsProductShipperActive_Fail()
		{
			bool retValue = DAL.BloodProduct.IsProductShipperActive(this._shipperProductGuid, System.Guid.NewGuid());

			Assert.AreEqual(false, retValue, "ReturnValue");
		}

		[Test]
		public void GetBloodProductByGuid_Pass()
		{
			DataTable dtTest = DAL.BloodProduct.GetBloodProductByGuid(this._activeBloodProductGuid);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(15, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.BloodProductGuid), TABLES.BloodProduct.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductAttributeForm), TABLES.BloodProduct.ProductAttributeForm);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassName), TABLES.ComponentClass.ComponentClassName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductCode), TABLES.BloodProduct.ProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.AboRhConfirmationRequired), TABLES.ProductType.AboRhConfirmationRequired);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductVolume), TABLES.BloodProduct.ProductVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.BarcodeType), ARTIFICIAL.BarcodeType);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ProductActiveIndicator), ARTIFICIAL.ProductActiveIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.HcpcsAssignment.HcpcsCode), TABLES.HcpcsAssignment.HcpcsCode);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetBloodProductByGuid_Fail()
		{
			DataTable dtTest = DAL.BloodProduct.GetBloodProductByGuid(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void BloodProductSearch_Pass()
		{
			DataTable dtTest = BloodProduct.BloodProductSearch(string.Empty, this._dtBloodProduct.Rows[0][TABLES.BloodProduct.ProductTypeCode].ToString());
			
			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(11, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.BloodProductGuid), TABLES.BloodProduct.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductCode), TABLES.BloodProduct.ProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductVolume), TABLES.BloodProduct.ProductVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.BarcodeType), ARTIFICIAL.BarcodeType);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ProductActiveIndicator), ARTIFICIAL.ProductActiveIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.HcpcsAssignment.HcpcsCode), TABLES.HcpcsAssignment.HcpcsCode);
		}

		[Test]
		public void BloodProductSearch_Fail()
		{
			DataTable dtTest = BloodProduct.BloodProductSearch(string.Empty, string.Empty);
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetTargetBloodProducts_Pass()
		{
			System.Guid fromGuid = (System.Guid)this._dtBloodProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];

			//Irradiate ('I' code) - has tons of products, but this is taking a chance on data not being there
			DataTable dtTest = DAL.BloodProduct.GetTargetBloodProducts(fromGuid.ToString(), 'I', Common.ModifyUnitMethod.Open);
			
			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(15, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.BloodProductGuid),  TABLES.BloodProduct.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductCode), TABLES.BloodProduct.ProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductVolume), TABLES.BloodProduct.ProductVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.BarcodeType), ARTIFICIAL.BarcodeType);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ProductActiveIndicator), ARTIFICIAL.ProductActiveIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.CodeAndShortName), ARTIFICIAL.CodeAndShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PermittedProductModification.ExpirationDateRule), TABLES.PermittedProductModification.ExpirationDateRule);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PermittedProductModification.MethodSelect), TABLES.PermittedProductModification.MethodSelect);
		}

		[Test]
		public void GetTargetBloodProducts_Fail()
		{
			System.Guid fromGuid = (System.Guid)this._dtBloodProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];

			DataTable dtTest = DAL.BloodProduct.GetTargetBloodProducts(fromGuid.ToString(), '?', Common.ModifyUnitMethod.Open);
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

	}
}
#endif
